#ifdef GL_ES
precision mediump float;

vec4 fragColor;
varying vec4 position;
#else
out vec4 fragColor;
in vec4 position;
#endif
uniform vec4 inColor;
uniform float stipplePattern;

void main()
{
    float halfStipple = stipplePattern / 2.0;
    if((mod(position.x, stipplePattern) < halfStipple) ^^ (mod(position.y, stipplePattern) < halfStipple))
    {
        discard;
    }
    fragColor = inColor;
#ifdef GL_ES
	gl_FragColor = fragColor;
#endif
}
